/* $Id: wince_ppc_NES_screen_mgr.cpp,v 1.2 2003/01/27 13:55:23 Rick Exp $ */
#include "wince_ppc_NES_screen_mgr.h"
#include "debug.h"

#ifdef _USES_GAPI_DISPLAY

wince_ppc_NES_screen_mgr::wince_ppc_NES_screen_mgr(HWND wnd_handle)
{
	// initialize GX
	if (!GXOpenDisplay(wnd_handle, GX_FULLSCREEN))
		THROW_EXCEPTION;
	gxdp = GXGetDisplayProperties();

	if (gxdp.cxWidth != 240 && gxdp.cyHeight != 320)
		THROW_EXCEPTION;

	memset(nes_palette, 0, sizeof(nes_palette));
	buffer = new uint8[get_width() * get_height()];
	nes_pal_start = 0;
	scr_ptr = 0;
}

wince_ppc_NES_screen_mgr::~wince_ppc_NES_screen_mgr()
{
	// delete GX
	GXCloseDisplay();
	delete [] buffer;
}

boolean wince_ppc_NES_screen_mgr::lock(pixmap& p)
{
	p.data = buffer;
	p.width = get_width();
	p.height = get_height();
	p.pitch = get_width();
	return TRUE;
}

boolean wince_ppc_NES_screen_mgr::unlock()
{
	return TRUE;
}

/*
void wince_ppc_NES_screen_mgr::blt()
{
	unsigned short* pscr = (unsigned short*)GXBeginDraw();
	if (pscr == NULL)
		return;

	unsigned char* pbuf = buffer;
	unsigned short* dest;
	int x, y;

	int xpitch = gxdp.cbxPitch >> 1;
	int ypitch = gxdp.cbyPitch >> 1;

	if (NESTER_settings.nes.graphics.osd.fullscreen) {
		int counter = 0;
		for (y = 0; y < 240; y++) {
			pbuf += 16;
			dest = pscr;
			if (counter) {
				// render 1line
				for (x = 0; x < 240; x++) {
					//*dest = (unsigned short)nes_palette[*pbuf - nes_pal_start];
					// Rick
					*dest = (unsigned short)nes_palette[*pbuf];
					dest += xpitch;
					pbuf++;
				}
				pscr += ypitch;
			}
			else {
				// render 2lines
				unsigned short* dest2 = dest + ypitch;
				for (x = 0; x < 240; x++) {
					//*dest2 = *dest = (unsigned short)nes_palette[*pbuf - nes_pal_start];
					// Rick
					*dest2 = *dest = (unsigned short)nes_palette[*pbuf];
					dest += xpitch;
					dest2 += xpitch;
					pbuf++;
				}
				pscr += ypitch * 2;
			}
			pbuf += 16;
			counter = (++counter) % 3;
		}
	}
	else {
		pscr += ypitch << 5; // top position
		for (y = 0; y < 240; y++) {
			pbuf += 16;
			dest = pscr;
			for (x = 0; x < 240; x++) {
				//*dest = (unsigned short)nes_palette[*pbuf - nes_pal_start];
				// Rick
				*dest = (unsigned short)nes_palette[*pbuf];
				dest += xpitch;
				pbuf++;
			}
			pbuf += 16;
			pscr += ypitch;
		}
	}

	GXEndDraw();
}
*/

#ifdef REPORT_FPS
#define PT 1

uint8 numbers[] = {
	PT, PT, PT,
	PT,  0, PT,
	PT,  0, PT,
	PT,  0, PT,
	PT, PT, PT,

	 0, PT,  0,
	 0, PT,  0,
	 0, PT,  0,
	 0, PT,  0,
	 0, PT,  0,

	PT, PT, PT,
	 0,  0, PT,
	PT, PT, PT,
	PT,  0,  0,
	PT, PT, PT,

	PT, PT, PT,
	 0,  0, PT,
	PT, PT, PT,
	 0,  0, PT,
	PT, PT, PT,

	PT,  0, PT,
	PT,  0, PT,
	PT, PT, PT,
	 0,  0, PT,
	 0,  0, PT,

	PT, PT, PT,
	PT,  0,  0,
	PT, PT, PT,
	 0,  0, PT,
	PT, PT, PT,

	PT, PT, PT,
	PT,  0,  0,
	PT, PT, PT,
	PT,  0, PT,
	PT, PT, PT,

	PT, PT, PT,
	 0,  0, PT,
	 0,  0, PT,
	 0,  0, PT,
	 0,  0, PT,

	PT, PT, PT,
	PT,  0, PT,
	PT, PT, PT,
	PT,  0, PT,
	PT, PT, PT,

	PT, PT, PT,
	PT,  0, PT,
	PT, PT, PT,
	 0,  0, PT,
	PT, PT, PT
};

extern int gFPS;
extern int g_update_fps;

void draw_digit(unsigned short *p, int xpitch, int ypitch, int d)
{
	if (d < 0 || d > 9)
		return;
	uint8 *data = &(numbers[15 * d]);
	for (int y = 0; y < 5; y++) {
		*p = (*data++) ? 0xffff : 0;
		*(p+xpitch) = (*data++) ? 0xffff : 0;
		*(p+xpitch*2) = (*data++) ? 0xffff : 0;
		p += ypitch;
	}
}

#ifdef REPORT_FPS
void wince_ppc_NES_screen_mgr::show_fps()
{
	if (g_update_fps) {
		int xpitch = gxdp.cbxPitch >> 1;
		int ypitch = gxdp.cbyPitch >> 1;

		unsigned short *pscr = scr_ptr_top + ypitch * (32 + 241);
		/*if (gFPS / 10) {
			draw_digit(pscr, ypitch, gFPS / 10);
			pscr += 4;
		}*/
		draw_digit(pscr, xpitch, ypitch, gFPS / 10);
		pscr += 4 * xpitch;
		draw_digit(pscr, xpitch, ypitch, gFPS % 10);
		g_update_fps = 0;
	}
}
#endif

#endif

void wince_ppc_NES_screen_mgr::blt()
{
	unsigned short* pscr = (unsigned short*)GXBeginDraw();
	if (pscr == NULL)
		return;

	unsigned char* pbuf = buffer;
	int x, y;

	int xpitch = gxdp.cbxPitch >> 1;
	int ypitch = gxdp.cbyPitch >> 1;

	scr_ptr_top = pscr;
	pscr += ypitch << 5; // top position

	// fullscreen stuff removed...

	if (xpitch == 1) {
		// do fast blit
		uint32 * dest;
		for (y = 240; y > 0; y--) {
			pbuf += 16;
			dest = (uint32 *)pscr;
			for (x = 40; x > 0; x--) {
				// 6 pixels per loop
				uint32 data = nes_palette[*pbuf++];
				data |= nes_palette[*pbuf++] << 16;
				*dest++ = data;
				
				data = nes_palette[*pbuf++];
				data |= nes_palette[*pbuf++] << 16;
				*dest++ = data;

				data = nes_palette[*pbuf++];
				data |= nes_palette[*pbuf++] << 16;
				*dest++ = data;
			}
			pbuf += 16;
			pscr += ypitch;
		}
	} else {
		unsigned short* dest;
		for (y = 0; y < 240; y++) {
			pbuf += 16;
			dest = pscr;
			for (x = 40; x > 0; x--) {
				// 6 pixels per loop
				*dest = (unsigned short)nes_palette[*pbuf++];
				dest += xpitch;
				*dest = (unsigned short)nes_palette[*pbuf++];
				dest += xpitch;
				*dest = (unsigned short)nes_palette[*pbuf++];
				dest += xpitch;
				*dest = (unsigned short)nes_palette[*pbuf++];
				dest += xpitch;
				*dest = (unsigned short)nes_palette[*pbuf++];
				dest += xpitch;
				*dest = (unsigned short)nes_palette[*pbuf++];
				dest += xpitch;
			}
			pbuf += 16;
			pscr += ypitch;
		}
	}
#ifdef REPORT_FPS
	show_fps();
#endif
	GXEndDraw();
}

void wince_ppc_NES_screen_mgr::begin_update()
{
	scr_ptr = scr_ptr_top = (unsigned short*)GXBeginDraw();
	scr_ptr += gxdp.cbyPitch << 4;
}

void wince_ppc_NES_screen_mgr::blt_line(uint8 * pbuf)
{
	if (scr_ptr == NULL)
		return;

	int xpitch = gxdp.cbxPitch >> 1;

	pbuf += 16;

	if (xpitch == 1) {
		uint32 * dest = (uint32 *)scr_ptr;
		for (int x = 40; x > 0; x--) {
			// 6 pixels per loop
			uint32 data = nes_palette[*pbuf++];
			data |= nes_palette[*pbuf++] << 16;
			*dest++ = data;
			
			data = nes_palette[*pbuf++];
			data |= nes_palette[*pbuf++] << 16;
			*dest++ = data;
			
			data = nes_palette[*pbuf++];
			data |= nes_palette[*pbuf++] << 16;
			*dest++ = data;
		}
	} else {
		unsigned short* dest = scr_ptr;
		for (int x = 40; x > 0; x--) {
			// 6 pixels per loop
			*dest = (unsigned short)nes_palette[*pbuf++];
			dest += xpitch;
			*dest = (unsigned short)nes_palette[*pbuf++];
			dest += xpitch;
			*dest = (unsigned short)nes_palette[*pbuf++];
			dest += xpitch;
			*dest = (unsigned short)nes_palette[*pbuf++];
			dest += xpitch;
			*dest = (unsigned short)nes_palette[*pbuf++];
			dest += xpitch;
			*dest = (unsigned short)nes_palette[*pbuf++];
			dest += xpitch;
		}
	}

	scr_ptr += gxdp.cbyPitch >> 1;
}

void wince_ppc_NES_screen_mgr::end_update()
{
	GXEndDraw();
}

void wince_ppc_NES_screen_mgr::flip()
{
}

void wince_ppc_NES_screen_mgr::clear(PIXEL color)
{
}

boolean wince_ppc_NES_screen_mgr::set_palette(const uint8 pal[256][3])
{
	return FALSE;
}

boolean wince_ppc_NES_screen_mgr::get_palette(uint8 pal[256][3])
{
	return FALSE;
}

boolean wince_ppc_NES_screen_mgr::set_palette_section(uint8 start, uint8 len, const uint8 pal[][3])
{
	memset(nes_palette, 0, sizeof(nes_palette));
	nes_pal_start = start;
	ASSERT((start + len) <= sizeof(nes_palette) / sizeof(nes_palette[0]));
	
	// convert palette for GX
	/*
	for (int i = 0; i < len; i++) {
		if (gxdp.ffFormat & kfDirect555)
			nes_palette[i] = (((DWORD)pal[i][0] << 7) & 0x7C00) | (((DWORD)pal[i][1] << 2) & 0x03e0) | ((DWORD)pal[i][2] >> 3);
		else// if (gxdp.ffFormat & kfDirect565)
			nes_palette[i] = (((DWORD)pal[i][0] << 8) & 0xf800) | (((DWORD)pal[i][1] << 3) & 0x07e0) | ((DWORD)pal[i][2] >> 3);
		//else if (gxdp.ffFormat & kfDirect888)
		//	nes_palette[i] = (DWORD)pal[i][0] << 16 | (DWORD)pal[i][1] << 8 | (DWORD)pal[i][2];
	}
	*/
	// Rick
	for (int i = 0; i < len; i++) {
		if (gxdp.ffFormat & kfDirect555)
			nes_palette[i] = (((DWORD)pal[i][0] << 7) & 0x7C00) | (((DWORD)pal[i][1] << 2) & 0x03e0) | ((DWORD)pal[i][2] >> 3);
		else// if (gxdp.ffFormat & kfDirect565)
			nes_palette[i] = (((DWORD)pal[i][0] << 8) & 0xf800) | (((DWORD)pal[i][1] << 3) & 0x07e0) | ((DWORD)pal[i][2] >> 3);
		//else if (gxdp.ffFormat & kfDirect888)
		//	nes_palette[i] = (DWORD)pal[i][0] << 16 | (DWORD)pal[i][1] << 8 | (DWORD)pal[i][2];
	}

	return TRUE;
}

boolean wince_ppc_NES_screen_mgr::get_palette_section(uint8 start, uint8 len, uint8 pal[][3])
{
	return FALSE;
}

void wince_ppc_NES_screen_mgr::assert_palette()
{
	set_NES_palette();
}

void wince_ppc_NES_screen_mgr::freeze()
{
	GXSuspend();
}

void wince_ppc_NES_screen_mgr::thaw()
{
	GXResume();
}

#endif //_USES_GAPI_DISPLAY